//
//  ResetUserDefaultsViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 12.03.23.
//

import Foundation
import UIKit
import BigInt

class ResetUserDefaultsViewController : UIViewController {
    override func viewDidLoad() {
        super.viewDidLoad()
        
        if let bundleID = Bundle.main.bundleIdentifier {
            UserDefaults.standard.removePersistentDomain(forName: bundleID)
        }

    }
    
    func isIBANEPCValidTest(_ iban: String) -> Bool {
            let ibanWithoutSpaces = iban.replacingOccurrences(of: " ", with: "")
            guard ibanWithoutSpaces.count >= 5 else {
                return false
            }
            
            // Country code
            let countryCode = String(ibanWithoutSpaces.prefix(2))
        
            // Prüfsumme""
            let checkDigits = ibanWithoutSpaces[2 ..< 4] // starts with "1" instead of "0"
        
        let remainingIBAN = ibanWithoutSpaces.dropFirst(4) + (transformCountryCode(countryCode: countryCode) ?? "") + "00"
            print(remainingIBAN)
        
        let rest = BigInt(remainingIBAN)! % 97
        let checksum : String = String(abs(rest - 98))
            
        print(rest)
        print(checksum)
        print(checkDigits)
        if(checksum == checkDigits) {
            return true
        } else {
            return false
        }
    }
    
    
    func transformCountryCode(countryCode: String) -> String? {
            switch countryCode {
            case "DE":
                return "1314"
            case "GB":
                return "1116"
            case "IT":
                return "1829"
            case "CY":
                return "1234"
            default:
                return "0000"
            }
    }

            }
